#!/bin/sh
cd "$(cd "$(dirname "$0")" && pwd)"
echo -e "\n"
echo "********** Ultima Exodus - Remastered by Fox Cunning **********"

function showError {
	echo "***************************"
	echo "*** Errors encountered! ***"
	echo "***************************"
	read -n 1 -s -r -p "Press any key to quit, or close this terminal window"
}

function fontsPatch {
	mv "$newfile" "old.nes"
	./xdelta3 -v -d -n -f -s "old.nes" "altfonts.vcdiff" "$newfile"
	if [ $? -ne 0 ]; then
		showError
	else
		rm -f "old.nes"
		finished
	fi
}

function finished {
	echo -e "\n"
	echo "*** All done! ***"
	read -n 1 -s -r -p "Press any key to quit, or close this terminal window"
}

sleep 1

echo -e "\n"
echo ".............."
echo "Applying Patch"
echo ".............."
echo -e "\n"

sleep 1

oldfile="Ultima - Exodus (U) [!].nes"

if [ ! -f "$oldfile" ]; then
	oldfile="Ultima - Exodus (U).nes"
fi

if [ ! -f "$oldfile" ]; then
	echo -e "\n"
	echo "***********************"
	echo "*** File not found! ***"
	echo "***********************"
	echo "Make sure either \"Ultima - Exodus \(U\) \[!\].nes\" or \"Ultima - Exodus \(U\).nes\""
	echo "is in the same folder as this file!"
	echo "..........................................................................."
	read -n 1 -s -r -p "Press any key to quit, or close this terminal window"
	exit
fi

# Main patch
newfile="Ultima - Exodus Remastered.nes"

chmod +x xdelta3
./xdelta3 -v -d -n -f -s "$oldfile" "Ultima - Exodus Remastered Patch.vcdiff" "$newfile"

if [ $? -ne 0 ]; then
	showError
	exit
fi

echo -e "\n"

# Alt fonts option
while true; do
	read -p "Do you wish to use the alternative, 'high-readability' fonts?" yn
	case $yn in
		[Yy]* ) fontsPatch; break;;
		[Nn]* ) finished; break;;
		* ) echo "Invalid choice! Please type Y or N";;
	esac
done
echo -e "\n"

